import waba.ui.*;
import waba.fx.*;
import waba.sys.*; 


public class Test extends MainWindow
{
Font boldFont;
Font plainFont;
String version = "version ";
Button butt;

/** Constructs the welcome application. */
public Test()
	{
	boldFont = new Font("Helvetica", Font.BOLD, 12);
	plainFont = new Font("Helvetica", Font.PLAIN, 12);
	int v = Vm.getVersion();
	version += (v / 100) + "." + (v % 100) + " for " + Vm.getPlatform();
		}

public void onStart() {
  Tab tab;
  TabBar tabBar = new TabBar();
  int v = Vm.getVersion(); 
  tab = new Tab("Waba VM"); // + v/100 + "." + v%100
  tabBar.add(tab);
  tabBar.setRect(0, 0, width, 30);
  add(tabBar);
	
  butt = new Button("Welcome");
  butt.setRect((width-80)/2, height-25, 80, 20);
  add(butt); 	
}	

/** Called by the system to pass events to the application. */
public void onEvent(Event e)
	{
/*	if (event.type == PenEvent.PEN_DOWN)
		exit(0);*/
	if (e.type == ControlEvent.PRESSED && e.target == butt) 
			exit(0);
		
	}

/** Called by the system to draw the application. */
public void onPaint(Graphics g)
	{
	int x = 0;
	int y = 0;

	FontMetrics boldFontMetrics = getFontMetrics(boldFont);
	FontMetrics plainFontMetrics = getFontMetrics(plainFont);

	// draw title
	String title = "Waba Virtual Machine";
	x = (this.width - boldFontMetrics.getTextWidth(title)) / 2;
	y = this.height / 2 - 60;
	g.setColor(0, 0, 0);
	g.setFont(boldFont);	
	g.drawText(title, x, y);
	y += boldFontMetrics.getHeight();

	// draw verion
	x = (this.width - plainFontMetrics.getTextWidth(version)) / 2;
	g.setColor(0, 0, 0);
	g.setFont(plainFont);
	g.drawText(version, x, y);

	// draw status
	String status = "WabaVM installed and ready";
	y += 40;
	x = (this.width - plainFontMetrics.getTextWidth(status)) / 2;
	g.drawText(status, x, y);

	String s;
	s = "GBAX.COM 2003 compo entry by ph0x";
	y += 50;
	x = (this.width - plainFontMetrics.getTextWidth(s)) / 2;
	g.drawText(s, x, y);

	// draw url
	String url = "http://www.gbax.com";
	y += boldFontMetrics.getHeight();
	int sw = plainFontMetrics.getTextWidth(url);
	x = (this.width - sw) / 2;
	g.setColor(0, 0, 0);
	int sh = plainFontMetrics.getHeight();
	g.fillRect(x - 2, y, sw + 4, sh);
	g.setColor(255, 255, 255);
	g.setFont(plainFont);
	g.drawText(url, x, y);
	}
} 